import flet as ft


def main(page: ft.Page):
    page.title = "1.2 Создание приложений Flet на Python"
    page.vertical_alignment = ft.MainAxisAlignment.START
    page.padding = 20
    page.scroll = ft.ScrollMode.AUTO

    # ----- ССЫЛКИ НА ЭЛЕМЕНТЫ (Ref) -----
    first_name = ft.Ref[ft.TextField]()
    last_name = ft.Ref[ft.TextField]()
    greetings = ft.Ref[ft.Column]()
    form_container = ft.Ref[ft.Column]()

    # ----- ОБРАБОТЧИКИ -----
    def say_hello(e):
        fn = first_name.current.value.strip()
        ln = last_name.current.value.strip()

        if not fn and not ln:
            return  # ничего не выводим, если всё пусто

        greetings.current.controls.append(
            ft.Text(f"Привет, {fn} {ln}!".strip())
        )

        # очищаем поля
        first_name.current.value = ""
        last_name.current.value = ""
        first_name.current.focus()
        page.update()

    def toggle_form(e):
        # показать, как работает disabled у контейнера
        form_container.current.disabled = not form_container.current.disabled
        e.control.text = (
            "Разблокировать форму"
            if form_container.current.disabled
            else "Заблокировать форму"
        )
        page.update()

    def toggle_greetings_visibility(e):
        # показать, как работает visible
        greetings.current.visible = not greetings.current.visible
        e.control.text = (
            "Показать приветствия"
            if not greetings.current.visible
            else "Скрыть приветствия"
        )
        page.update()

    # ----- ЗАГОЛОВОК / ОПИСАНИЕ -----
    page.add(
        ft.Text("1.2 Создание приложений Flet на Python", size=22, weight="bold"),
        ft.Text(
            "Демонстрация: структура приложения, элементы управления, "
            "обработчики событий, свойства visible/disabled и ссылки (Ref).",
        ),
        ft.Divider(),
    )

    # ----- ФОРМА С Ref -----
    form = ft.Column(
        ref=form_container,
        controls=[
            ft.TextField(ref=first_name, label="Имя", autofocus=True),
            ft.TextField(ref=last_name, label="Фамилия"),
            ft.ElevatedButton("Поздороваться", on_click=say_hello),
        ],
    )

    # ----- БЛОК ПРИВЕТСТВИЙ -----
    greetings_column = ft.Column(ref=greetings)

    # делаем изначально видимым
    greetings_column.visible = True

    # ----- ДОБАВЛЯЕМ НА СТРАНИЦУ -----
    page.add(
        form,
        ft.Row(
            [
                ft.ElevatedButton("Заблокировать форму", on_click=toggle_form),
                ft.ElevatedButton(
                    "Скрыть приветствия",
                    on_click=toggle_greetings_visibility,
                ),
            ],
            spacing=10,
        ),
        ft.Text("Приветствия:", weight="bold"),
        greetings_column,
    )


if __name__ == "__main__":
    # Запуск в отдельном окне
    ft.app(target=main)

    # Если нужно в браузере, можно так:
    # ft.app(target=main, view=ft.WEB_BROWSER)
